#include "common.fx"

#define MAX_DARKEN    0.75
#define MAX_LIGHTEN   0.75

struct VS_OUTPUT2 {
    float4 position   : POSITION;
    float4 color      : COLOR0;
    float4 color_add  : COLOR1;
    float2 uv         : TEXCOORD0;
};

VS_OUTPUT2 vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0,
                        float4 color_add : COLOR1,
                        float2 uv: TEXCOORD0) {
    VS_OUTPUT2 output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;
    output.color_add = color_add + global_color_add;
    output.uv = uv;
    return output;
}

#if 0
texture normal_texture;

sampler NormalTextureSampler = 
sampler_state {
    Texture = <normal_texture>;    
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
#endif

PS_OUTPUT pixel_shader(VS_OUTPUT2 input) {
    PS_OUTPUT output;

    float4 texture_color = sample_diffuse(input.uv);

    output.color = input.color * texture_color + input.color_add;
    output.color.rgb *= output.color.a; // need to use premultiplied alpha

#ifdef MRT_REWIND
    output.color2 = rewindable_alpha;
    output.color2.a = output.color.a;
#endif

    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_2_0 pixel_shader();

        AlphaBlendEnable = True;
        SrcBlend = One;
        DestBlend = InvSrcAlpha;
        AlphaTestEnable = True;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}


